/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: UStaticCppDrvNT.cpp,v 1.1 1999/09/12 04:33:35 nryan Exp $
____________________________________________________________________________*/

#include "pgpClassesConfig.h"
#include "UStaticCpp.h"

_USING_PGP

_UNNAMED_BEGIN

// Types

typedef void (_cdecl *PtrVoidFunc)(void);

struct AtExitEntry
{
	PtrVoidFunc func;
	AtExitEntry *next;
};

// Static variables

AtExitEntry *AtExitEntryList = NULL;

_UNNAMED_END


// Exported variables

#pragma data_seg(".CRT$XCA")
PtrVoidFunc __xc_a[] = {NULL};
#pragma data_seg(".CRT$XCZ")
PtrVoidFunc __xc_z[] = {NULL};
#pragma data_seg()


// Functions

int 
_cdecl 
atexit(PtrVoidFunc func)
{
	AtExitEntry	*newEntry;

	newEntry = new AtExitEntry;

	if (IsNull(newEntry))
		return 0;

	newEntry->func = func;

	newEntry->next = AtExitEntryList;
	AtExitEntryList = newEntry;

	return 1;
}

void  
UStaticCpp::CallGlobalConstructors()
{
	PtrVoidFunc	*pfbegin, *pfend;

	pfbegin = __xc_a;
	pfend = __xc_z;

	while (pfbegin < pfend)
	{
		if (*pfbegin != NULL)
			(**pfbegin)();

		++pfbegin;
	}
}

void 
UStaticCpp::CallGlobalDestructors()
{
	AtExitEntry	*curEntry, *nextEntry;

	curEntry = AtExitEntryList;

	while (IsntNull(curEntry))
	{
		curEntry->func();
		nextEntry = curEntry->next;
		delete curEntry;
		curEntry = nextEntry;
	}
}
